@extends ('../welcome')


@section('content')

<style>
    #upload-photo {
        display: none;
    }

    .pagination nav .relative.z-0.inline-flex {
        display: inline-flex;
    }

    .pagination nav .hidden {
        display: unset !important;
    }

    .pagination nav .flex-1.justify-between {
        padding: 15px 0
    }

    .pagination nav .flex.justify-between.flex-1 {
        display: none
    }
</style>
    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Sources</div>
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('sources-create'))
                    <a href="{{ route('sources.create') }}">
                        <button class="btn btn-square btn-light active" type="button" style="float:left; margin-left:20px;"><i
                                class="fas fa-plus"></i></button>
                    </a>
                @endif
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="card-title">Total: {{ count($allSources) }}</div>
            </div>
            <div class="card-body">
                <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('sources-export') ? 'example1' : 'nonExport' }} 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Project</th>
                            <th>SourceType</th>
                            <th>Campaign</th>
                            <th>Created Date</th>
                            <th>Created Time</th>

                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($sources as $source)
                            <?php $temp = explode(' ', $source->created_at); ?>

                            <tr>
                                <td>{{ $source->id }}</td>
                                <td>{{ $source->name }}</td>
                                <td>{{ $source->project?->name }}</td>
                                <td>{{ $source->sourceType?->name }}</td>
                                <td>{{ $source->campaign?->name ?? ''}}</td>
                                <td>{{ $temp[0] }}</td>
                                <td>{{ $temp[1] }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('sources-edit'))
                                        <a class="btn btn-primary" title="Edit"
                                            href="{{ route('sources.edit', $source->id) }}">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('sources-show'))
                                        <a class="btn btn-warning" title="Show"
                                            href="{{ route('sources.show', $source->id) }}">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                    @endif
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-delete'))
                                        @if (count($source->leads) == 0)
                                            <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                                data-id="{{ $source->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                </table>
                <div class="pagination">
                    {{ $sources->appends(request()->input())->links() }}
                </div>
                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalCenter" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Delete Record</h5>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure to delete this record ?</p>
                            </div>
                            <form class="modal-footer" method="post">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.row -->
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('sources.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }

        function updateTextInput(val) {
            document.getElementById('textInput').value = val;
        }
    </script>
@endsection
