@extends ('../welcome')


@section ('content')

<!-- Filters -->
<div class="col-4">
    <div class="card">
        <div class="card-body">
            <form>
                <div class="row">
                    <div class="form-group col-6">
                        <label>From</label>
                        <input type="date" name="date1" class="form-control" required>
                    </div>
                    <div class="form-group col-6">
                    <label>To</label>
                        <input type="date" name="date2" class="form-control" required>
                    </div>
                </div>

                <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                <button type="submit" class="btn btn-info" style="float:left">filter</button>

            </form>
        </div>
    </div>
</div>
<!-- End filters -->
<div class="card">
    <!-- /.card-header -->
    <div class="card-body">
        <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('delay-tickets-export') ? 'example1' : 'nonExport' }} 
            class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Client</th>
                    <th>project</th>
                    <th>unit</th>
                    <th>User Id</th>
                    <th>Status</th>
                    <th>Call Date</th>
                    <th>Deadline</th>
                    <th>Ticket Type</th>
                    <th>Communication Method</th>

                    <th>Created Date</th>
                    <th>Created Time</th>

                    <th>Last update Date</th>
                    <th>Last update Time</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($tickets as $ticket)
                <?php $temp = explode(' ',$ticket->created_at->setTimezone('Africa/Cairo'));?>
                <?php $temp2 = explode(' ',$ticket->updated_at->setTimezone('Africa/Cairo'));?>

                <tr>
                    <td>{{$ticket->id}}</td>
                    <td>
                        <a href="{{route('clients.show', $ticket->client->id)}}">
                            {{$ticket->client->name}}
                        </a>
                    </td>

                    <td>
                        <a href="{{route('projects.show', $ticket->project->id)}}">
                            {{$ticket->project->name}}
                        </a>
                    </td>
                    <td>
                        <a href="{{route('units.show', $ticket->unit->id)}}">
                        {{$ticket->unit->name}}
                        </a>
                    </td>
                    <td>
                        <a href="{{route('users.show', $ticket->user_id)}}">
                            {{$ticket->user_id}}
                        </a>
                    </td>
                    <td>{{$ticket->status}}</td>
                    <td>{{$ticket->call_date}}</td>
                    <td>{{$ticket->deadline}}</td>
                    <td>{{$ticket->ticket_type->name}}</td>
                    <td>{{$ticket->method->name}}</td>
                    <td>{{$temp[0]}}</td>
                    <td>{{$temp[1]}}</td>
                    <td>{{$temp2[0]}}</td>
                    <td>{{$temp2[1]}}</td>
                    <td>
                        <a class="btn btn-info" href="{{ route('tickets.show',$ticket->id) }}">Show</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
</div>


@endsection