@extends ('../welcome')

@section('content')
    <form action="{{ route('users.update', $user->id) }}" method="POST">
        <div class="card">
            <div class="row">
                <div class="col-6">
                    <div class="register-box">
                        <div class="card-body register-card-body">
                            <p class="login-box-msg">Add new membership</p>
                            @csrf
                            @method('PUT')
                            <!-- <input type="hidden" name="user_id" value="{{ $user->id }}"> -->
                            <div class="input-group mb-3">
                                <input type="text" name="name" class="form-control" value="{{ $user->name }}"
                                    placeholder="Full name" required autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input type="email" class="form-control" placeholder="Email" value="{{ $user->email }}"
                                    name="email" require>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-envelope"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">

                                <input type="password" id="password" class="form-control p-relative" placeholder="Password"
                                    name="password" require>

                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <img onclick="replaceImageName()" src="{{ asset('asset/images/close.png') }}"
                                            width="30px" height="30px" id="peekEmoji" alt=""
                                            style="position: absolute;
                                    z-index: 100;
                                    right: 10px;
                                    top: 5px;">
                                    </div>
                                </div>
                            </div>
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('users-assignRole'))
                                <div class="form-group">
                                    <label for="userRole">Select User Role</label>
                                    <select name="role_id" class="select2 custom-select form-control-border" id="userRole">
                                        <option value="">--</option>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->id }}"
                                                {{ $role->id == $user->role_id ? 'selected' : '' }}>
                                                {{ $role->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif

                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('users-assignLeader'))
                                <div class="form-group">
                                    <label for="users">Assign To</label>
                                    <select name="assigned_to" class="select2 custom-select form-control-border"
                                        id="users">
                                        <option value="">--</option>
                                        <option value="{{ auth()->user()->id }}"
                                            {{ auth()->user()->id == $user->assigned_to ? 'selected' : '' }}>
                                            {{ auth()->user()->name }}</option>
                                        @for ($i = 0; $i < count($UserChildren); $i++)
                                            <option value="{{ $UserChildren[$i]['id'] }}"
                                                {{ $UserChildren[$i]['id'] == $user->parent?->id ? 'selected' : '' }}>
                                                {{ $UserChildren[$i]['name'] }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>
                            @endif

                            <div class="col-6" style="float:right;">
                                <button type="submit" class="btn btn-info">Edit User Data</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-6">
                    <div id="inputFormRow">
                        @forelse($user->phones as $phone)
                            <div id="inputFormRow">
                                <div class="row card-body">
                                    <div class="col-4">
                                        <p class="login-box-msg">Country</p>

                                        <select name="country_id[]" class="select2 custom-select form-control-border"
                                            id="Country">
                                            @foreach ($countries as $country)
                                                <option value="{{ $country->id }}"
                                                    {{ $country->id == $phone->country->id ? 'selected' : '' }}>
                                                    {{ $country->name }}
                                                    +{{ $country->phonecode }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-6">
                                        <p class="login-box-msg">phone number</p>
                                        <input type="text" class="form-control m-input" value="{{ $phone->phone }}"
                                            placeholder="Phone Number" name="mobile_number[]" id="phone" required>
                                    </div>
                                    <div class="col-2" style="padding-top:43px;">
                                        <button id="removeRow" type="button" class="btn btn-danger">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div id="inputFormRow">
                                <div class="row">
                                    <div class="col-4">
                                        <p class="login-box-msg">Country</p>

                                        <select name="country_id[]" class="select2 custom-select form-control-border"
                                            id="Country">
                                            @foreach ($countries as $country)
                                                <option value="{{ $country->id }}">{{ $country->name }}
                                                    +{{ $country->phonecode }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-5">
                                        <p class="login-box-msg">phone number</p>
                                        <input type="text" class="form-control m-input" placeholder="Phone Number"
                                            name="mobile_number[]" id="phone" required>
                                    </div>
                                    <div class="col-3" style="padding-top:43px;">
                                        <div class="row" style="justify-content: space-between">
                                            <button id="removeRow" type="button" class="btn btn-danger mx-3 ">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                            <button id="addRow" type="button" class="btn btn-info">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        @endforelse
                        <div id="newRow"></div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        function replaceImageName() {
            let peekEmoji = document.getElementById('peekEmoji');
            var imageName = peekEmoji.src.split("/").pop();
            let newImageName = peekEmoji.src
            let password = document.getElementById('password');

            if (password.type === 'password') {
                password.type = 'text'
            } else {
                password.type = 'password'
            }

            if (peekEmoji.src.endsWith('close.png')) {
                peekEmoji.src = peekEmoji.src.replace(imageName, 'peek.gif')
            } else if (peekEmoji.src.endsWith('peek.gif')) {
                peekEmoji.src = peekEmoji.src.replace(imageName, 'close.png')

            }
        }


        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
    <div id="inputFormRow">
        <div class="row" >
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                <select name="country_id[]" class="select2 custom-select form-control-border" id="Country">
                    @foreach ($countries as $country)
                    <option value="{{ $country->id }}">{{ $country->name }} +{{ $country->phonecode }}</option>
                    @endforeach
                </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" value="{{ old('phone_number') }}"
                    placeholder="Phone Number"  id="phone" required name="mobile_number[]">
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#newRow').append(html);
        });
        // remove row
        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });
    </script>
@endsection
