

<?php $__env->startSection('content'); ?>
    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">

                <h3 class="card-title">Archived Leads & CILs</h3><br>
                <p>Total: <?php echo e(count($leads)); ?></p>
                <?php if(auth()->user()->role->hasPermission('leads-restorAll')): ?>
                    <a href="<?php echo e(route('leads.restoreAll')); ?>" title="Restore All" style="float:right">
                        <button class="btn btn-square btn-outline-success" type="button"><i
                                class="fas fa-trash-restore-alt"></i></button>
                    </a>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('leads-archive-export') ? 'example1' : 'nonExport'); ?> 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Type</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($lead->id); ?></td>
                                <td><?php echo e($lead->name); ?></td>
                                <td><?php echo e($lead->email); ?></td>

                                <td><?php echo e(ucwords($lead->status)); ?></td>
                                <td><?php echo e($lead->type); ?></td>
                                <td><?php echo e($lead->created_at->setTimezone('Africa/Cairo')); ?></td>
                                <td>
                                    <?php if(auth()->user()->role->hasPermission('leads-restore')): ?>
                                        <a class="btn btn-success" title="Restore"
                                            href="<?php echo e(route('leads.restore', $lead->id)); ?>">
                                            <i class="fas fa-trash-restore"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->role->hasPermission('delete-permanently')): ?>
                                        <a href="<?php echo e(route('leads.deletePermanently', $lead->id)); ?>">
                                            <button title="Delete" class="btn btn-danger">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        </a>
                                    <?php endif; ?>
                                </td>
                                
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Nesma\Work\peacode\CRM\resources\views/leads/archive.blade.php ENDPATH**/ ?>