
<?php $__env->startSection('content'); ?>
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>
    <!-- Filters -->
    <form>
        <div class="card card-info card-outline collapsed-card">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title" style="font-weight:bold; font-size:20px">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('communications.index')); ?>">
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label>Creator</label>
                                <select name="creators_id[]" class="select2 custom-select form-control-border" multiple>
                                    <?php $__currentLoopData = $creators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $creator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($creator->id); ?>" <?php echo e(isset(Request::get('creators_id')[0]) && in_array($creator->id, Request::get('creators_id')) ? 'selected' : ''); ?>><?php echo e($creator->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Status</label>
                                <select name="callActions_id[]" class="select2 custom-select form-control-border" multiple>
                                    <?php $__currentLoopData = $callActions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $callAction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($callAction->id); ?>" <?php echo e(isset(Request::get('callActions_id')[0]) && in_array($callAction->id, Request::get('callActions_id')) ? 'selected' : ''); ?>><?php echo e($callAction->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Leads</label>
                                <select name="leads_id[]" class="select2 custom-select form-control-border" multiple>
                                    <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($lead->id); ?>" <?php echo e(isset(Request::get('leads_id')[0]) && in_array($lead->id, Request::get('leads_id')) ? 'selected' : ''); ?>><?php echo e($lead->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            

                        </div>

                        <div class="col-6">
                            <div class="row">
                                <div class="form-group col-6">
                                    <label>From</label>
                                    <input type="time" value="<?php echo e($_GET['time1'] ?? ''); ?>" class="form-control"
                                        name="time1">
                                </div>
                                <div class="form-group col-6">
                                    <label>to</label>

                                    <input type="time" name="time2" value="<?php echo e($_GET['time2'] ?? ''); ?>"
                                        class="form-control">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-6">
                                    <input type="date" name="date1" value="<?php echo e($_GET['date1'] ?? ''); ?>"
                                        class="form-control">
                                </div>
                                <div class="form-group col-6">
                                    <input type="date" name="date2" value="<?php echo e($_GET['date2'] ?? ''); ?>"
                                        class="form-control">
                                </div>
                            </div>

                            <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default">Back</a>
                            <button type="submit" class="btn btn-info" style="float:left">filter</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </form>

    <!-- End filters -->

    <!-- /.row -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title"> All Actions and Dates</div><br>
                </div>
                <div class="card-body">
                    <div class="card-title">Total: <?php echo e(count($totalActions)); ?></div>
                    <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('actions-export') ? 'example2' : 'nonExport'); ?> 
                        class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Lead Name</th>
                                <th>Phone</th>
                                <th>Status</th>
                                <th>Comment</th>
                                <th>Date</th>
                                <!--<th>Type</th>-->
                                <!--<th>Next Action Date</th>-->
                                <th>Created By</th>
                                <th>View</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $communications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $communication): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($communication->broker_id == null && !empty($communication->lead)): ?>
                                    <tr>
                                        <td><?php echo e($communication->id); ?></td>
                                        
                                        <td>
                                            <?php if(auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('leads-show')): ?>
                                                <a href="<?php echo e(route('leads.show', $communication->lead->id)); ?>">
                                                    <?php echo e($communication->lead->name ?? ''); ?>

                                                </a>
                                            <?php else: ?>
                                                <a>
                                                    <?php echo e($communication->lead->name ?? ''); ?>

                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php $__currentLoopData = $communication->lead->phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($phone->country->phonecode); ?> <?php echo e($phone->phone); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>

                                        <td>
                                            <?php echo e($communication->lead->LeadStatus->name); ?>

                                        </td>

                                        <td title="Open the Event To Change Status">
                                            <?php echo e($communication->description); ?>

                                        </td>
                                    
                                        <td><?php echo e($communication->created_at); ?></td>

                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-show')): ?>
                                            <td>
                                                <a href="<?php echo e(route('users.show', $communication->user->id)); ?>">
                                                    <?php echo e($communication->user?->name); ?>

                                                </a>
                                            </td>
                                            <?php else: ?>
                                            <td>
                                                <?php echo e($communication->user?->name); ?>

                                            </td>
                                        <?php endif; ?>
                                        
                                        <td>
                                            <?php if(auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('communications-show')): ?>
                                                <form action="" method="POST">
                                                    <a class="btn btn-light" title="Show"
                                                        href="<?php echo e(route('communications.show', $communication->id)); ?>">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    <?php echo csrf_field(); ?>
                                                </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <div class="pagination">
                        <?php echo e($communications->appends(request()->input())->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Nesma\Work\peacode\CRM\resources\views/communications/index.blade.php ENDPATH**/ ?>